/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftVersion;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BlockColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.Block;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ChunkMetadata;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundMap;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.StringTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderer_1_13
extends ChunkRenderer {
    private static Logger log = LogManager.getLogger(ChunkRenderer_1_13.class);

    public ChunkRenderer_1_13(RenderSettings settings) {
        super(MinecraftVersion.MC_1_13, settings);
    }

    @Override
    ChunkMetadata renderChunk(Vector2ic chunkPosRegion, Vector2ic chunkPosWorld, CompoundTag level, Color[] map, int[] height, String[] regionBiomes) {
        this.blockColors = this.settings.blockColors.get((Object)this.version);
        try {
            String generationStatus = (String)((Tag)level.getValue().get("Status")).getValue();
            if (generationStatus == null) {
                log.warn("Could not parse generation status: " + ((Tag)level.getValue().get("Status")).getValue());
                generationStatus = "empty";
            }
            if (ChunkMetadata.ChunkMetadataRendered.STATUS_EMPTY.contains(generationStatus)) {
                return new ChunkMetadata.ChunkMetadataRendered(chunkPosWorld, generationStatus);
            }
            HashMap<String, Vector3ic> structureCenters = new HashMap<String, Vector3ic>();
            if (level.getValue().containsKey("Structures") && ((CompoundTag)level.getValue().get("Structures")).getValue().containsKey("Starts")) {
                CompoundMap structures = ((CompoundTag)((CompoundTag)level.getValue().get("Structures")).getValue().get("Starts")).getValue();
                for (Tag<?> structureTag : structures.values()) {
                    CompoundMap structure = ((CompoundTag)structureTag).getValue();
                    String id = ((StringTag)structure.get("id")).getValue();
                    if (id.equals("INVALID")) continue;
                    int[] bb = ((Tag)structure.get("BB")).getAsIntArrayTag().get().getValue();
                    Vector3i center = new Vector3i(bb[0], bb[1], bb[2]).add(bb[3], bb[4], bb[5]);
                    center.x /= 2;
                    center.y /= 2;
                    center.z /= 2;
                    structureCenters.put(id, center);
                }
            }
            String[] biomes = level.getIntArrayValue("Biomes").map(ints -> {
                String[] strings = new String[256];
                for (int i = 0; i < 256; ++i) {
                    strings[i] = Integer.toString(ints[i]);
                }
                return strings;
            }).orElse(new String[256]);
            int lowestLoadedSection = 16;
            Block[][] loadedSections = new Block[16][];
            Map<Byte, CompoundMap> sections = level.getValue().getOrDefault("Sections", new ListTag("sections", TagType.TAG_COMPOUND, Collections.emptyList())).getValue().stream().collect(Collectors.toMap(s -> (Byte)((Tag)s.getValue().get("Y")).getValue(), s -> s.getValue()));
            boolean mayCull = chunkPosWorld.x() << 4 < this.settings.minX || (chunkPosWorld.x() << 4) + 16 > this.settings.maxX || chunkPosWorld.y() << 4 < this.settings.minZ || (chunkPosWorld.y() << 4) + 16 > this.settings.maxZ;
            for (int z = 0; z < 16; z = (int)((byte)(z + 1))) {
                for (int x = 0; x < 16; x = (int)((byte)(x + 1))) {
                    if (mayCull && (x + (chunkPosWorld.x() << 4) < this.settings.minX || x + (chunkPosWorld.x() << 4) > this.settings.maxX || z + (chunkPosWorld.y() << 4) < this.settings.minZ || z + (chunkPosWorld.y() << 4) > this.settings.maxZ)) continue;
                    regionBiomes[chunkPosRegion.x() << 4 | x | chunkPosRegion.y() << 13 | z << 9] = biomes[x | z << 4];
                    boolean heightSet = false;
                    boolean discardTop = this.blockColors.isCaveView();
                    class ColorColumn {
                        Color color = Color.TRANSPARENT;
                        Color lastColor = Color.TRANSPARENT;
                        int lastColorTimes = 0;
                        boolean needStop = false;

                        ColorColumn() {
                        }

                        void putColor(Color currentColor) {
                            this.putColor(currentColor, 1);
                        }

                        void putColor(Color currentColor, int times) {
                            if (currentColor.equals(this.lastColor)) {
                                this.lastColorTimes += times;
                            } else {
                                this.color = Color.alphaUnder(this.color, this.lastColor, this.lastColorTimes);
                                this.lastColorTimes = times;
                                this.lastColor = currentColor;
                            }
                            if ((double)currentColor.a > 0.9999) {
                                this.needStop = true;
                            }
                        }

                        Color getFinal() {
                            this.putColor(Color.TRANSPARENT);
                            return this.color;
                        }
                    }
                    ColorColumn color = new ColorColumn();
                    block7: for (int s2 = 15; s2 >= 0; s2 = (int)((byte)(s2 - 1))) {
                        if (s2 << 4 > this.settings.maxY) continue;
                        if (s2 < lowestLoadedSection) {
                            try {
                                loadedSections[s2] = this.renderSection(sections.get((byte)s2));
                            }
                            catch (Exception e) {
                                log.warn("Failed to render chunk (" + chunkPosRegion.x() + ", " + chunkPosRegion.y() + ") section " + (byte)s2 + ". This is very likely because your chunk is corrupt. If possible, please verify it manually before sending a bug report.", (Throwable)e);
                                return new ChunkMetadata.ChunkMetadataFailed(chunkPosWorld, e);
                            }
                            lowestLoadedSection = s2;
                        }
                        if (loadedSections[s2] == null) {
                            color.putColor(this.blockColors.getAirColor().color, 16);
                            discardTop = false;
                            continue;
                        }
                        for (int y = 15; y >= 0; --y) {
                            if ((y | s2 << 4) < this.settings.minY) break block7;
                            if ((y | s2 << 4) > this.settings.maxY) continue;
                            int i = x | z << 4 | y << 8;
                            Block block = loadedSections[s2][i];
                            BlockColorMap.BlockColor colorData = this.blockColors.getBlockColor(block.name, block.state);
                            Color currentColor = colorData.color;
                            if (colorData.isGrass) {
                                currentColor = Color.multiplyRGB(currentColor, this.settings.biomeColors.getBiomeColor((String)biomes[i & 0xFF]).grassColor);
                            }
                            if (colorData.isFoliage) {
                                currentColor = Color.multiplyRGB(currentColor, this.settings.biomeColors.getBiomeColor((String)biomes[i & 0xFF]).foliageColor);
                            }
                            if (colorData.isWater) {
                                currentColor = Color.multiplyRGB(currentColor, this.settings.biomeColors.getBiomeColor((String)biomes[i & 0xFF]).waterColor);
                            }
                            if (discardTop && colorData.isTranslucent) {
                                discardTop = false;
                            }
                            if (!(discardTop || colorData.isTranslucent || heightSet)) {
                                height[chunkPosRegion.x() << 4 | x | chunkPosRegion.y() << 13 | z << 9] = s2 << 4 | y;
                                heightSet = true;
                            }
                            if (!discardTop) {
                                color.putColor(currentColor);
                            }
                            if (color.needStop) break block7;
                        }
                    }
                    map[chunkPosRegion.x() << 4 | x | chunkPosRegion.y() << 13 | z << 9] = color.getFinal();
                }
            }
            return new ChunkMetadata.ChunkMetadataRendered(chunkPosWorld, generationStatus, structureCenters);
        }
        catch (Exception e) {
            log.warn("Failed to render chunk (" + chunkPosRegion.x() + ", " + chunkPosRegion.y() + ")", (Throwable)e);
            return new ChunkMetadata.ChunkMetadataFailed(chunkPosWorld, e);
        }
    }

    private Block[] renderSection(CompoundMap section) {
        if (section == null) {
            return null;
        }
        List palette = ((ListTag)section.get("Palette")).getValue().stream().map(Tag::getValue).map(map -> new Block(((StringTag)map.get("Name")).getValue(), ChunkRenderer_1_13.parseBlockState((CompoundTag)map.get("Properties"), this.version.getBlockStates()))).collect(Collectors.toList());
        long[] blocks = ((Tag)section.get("BlockStates")).getAsLongArrayTag().get().getValue();
        int bitsPerIndex = blocks.length * 64 / 4096;
        Block[] ret = new Block[4096];
        for (int i = 0; i < 4096; ++i) {
            Block block;
            long blockIndex = Chunk.extractFromLong1_13(blocks, i, bitsPerIndex);
            if (blockIndex >= (long)palette.size()) {
                log.warn("Block " + i + " " + blockIndex + " was out of bounds, is this world corrupt?");
                continue;
            }
            ret[i] = block = (Block)palette.get((int)blockIndex);
        }
        return ret;
    }
}

